/******************************************************************************
                                                   COPYRIGHT (c) FREESCALE 2005  
                                                                           
 File Name          :    $RCSfile: S12XEBIV3.h,v $                         
                                                                           
 Current Revision :      $Revision: 1.0 $                                  
                                                                           
 PURPOSE: header file for S12X External Bus Interface (EBI) block          
                                                                           
 DESCRIPTION: Defines the EBI control registers as a data structures of   
              type tEBICTL0 and tEBICTL1.                                      
                                                                           
 UPDATE HISTORY                                                            
 REV  AUTHOR     DATE       DESCRIPTION OF CHANGE                          
 ---  ------    --------    ---------------------                          
 1.0  r32151    01/09/05    Initial Coding based on S12XEBIV2.h


     *******************************************************************
     * File created by: Freescale East Kilbride MCD Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

#ifndef S12XEBIV3_H        /*prevent duplicated includes */
#define S12XEBIV3_H

#include "S12_COMMON.h"

typedef union uEBICTL0
  {
  tU08  byte;
  struct
    {
    tU08 asiz   :5;     /* external address bus size */
    tU08 hdbe   :1;     /* high data byte enable */
    tU08        :1;     /* not used */     
    tU08 ithrs  :1;     /* Reduced Input threshold */
    }bit;
  }tEBICTL0;

/* bit masks for EBICTL0 */
#define HDBE    0x20
#define ITHRS   0x80

typedef union uEBICTL1
  {
  tU08  byte;
  struct
    {
    tU08 exstr0  :4;     /* chip select stretch0 enables  */
    tU08 exstr1  :4;     /* chip select stretch1 enables  */
    }bit;
  }tEBICTL1;

/* bit masks for EBICTL1 */
#define EXSTR00   0x01
#define EXSTR01   0x02
#define EXSTR02   0x04
#define EXSTR03   0x04
#define EXSTR10   0x10
#define EXSTR11   0x20
#define EXSTR12   0x40
#define EXSTR13   0x40

#endif /*S12XEBIV3_H */
